/* @(#) somx/direntry.c 2.3 1/20/94 10:24:31 [5/15/94 17:59:19] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define dirEntry_Class_Source
#define SOMClass_Class_Source
#include <direntry.ih>
#include <string.h>

/*
 ===============================================================================
 Operation: mkEntry
 Purpose  : Initialize new entry.
 ===============================================================================
 */

SOM_Scope void  SOMLINK mkEntry(dirEntry somSelf, string name,
                                string phone_no)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","mkEntry");

    if (_name) SOMFree(_name);
    _name = (string)SOMMalloc(strlen(name)+1);
    strcpy (_name, name);
    if (_phone) SOMFree(_phone);
    _phone = (string)SOMMalloc(strlen(phone_no)+1);
    strcpy (_phone, phone_no);
}

/*
 ===============================================================================
 Operation: lsEntry
 Purpose  : displays the entry on a single line.
 ===============================================================================
 */

SOM_Scope void  SOMLINK lsEntry(dirEntry somSelf)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","lsEntry");

    somPrintf ("%-16s    %-16s\n", _name, _phone);
}

/*
 ===============================================================================
 Operation: somInit
 ===============================================================================
 */

SOM_Scope void  SOMLINK somInit(dirEntry somSelf)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","somInit");

    dirEntry_parent_SOMPPersistentObject_somInit(somSelf);
    _name = NULL;
    _phone = NULL;
}

/*
 ===============================================================================
 Operation: somUninit
 Purpose: Free object resources.
          Note: if default attribute set methods are used, the caller is
          assumed to have malloc'd the memory. (i.e. for _set_name and
          _set_phone)
 ===============================================================================
 */

SOM_Scope void  SOMLINK somUninit(dirEntry somSelf)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","somUninit");

    if (_name) SOMFree(_name);
    if (_phone) SOMFree(_phone);
    dirEntry_parent_SOMPPersistentObject_somUninit(somSelf);
}

/*
 ===============================================================================
 Operation: sompIsDirty
 Purpose: override SOMPPersistentObject method to return actual
          "dirty" state.
 ===============================================================================
 */

SOM_Scope boolean  SOMLINK sompIsDirty(dirEntry somSelf,  Environment *ev)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","sompIsDirty");

    return (_sompGetDirty(somSelf, ev));
}

